#ifndef CRFEPURNETWORKANALYZER_H
#define CRFEPURNETWORKANALYZER_H

#include "../../ui/TabWidget.h"
#include "../../ui/ConfigDialog.h"
#include <ui_CRfePurNetworkAnalyzer.h>

#include <QrfeComplexNumber>

class QStandardItemModel;

class QWizard;
class QWizardPage;

class QwtPlot;
class QwtPlotCurve;
class QwtPlotPicker;

class QrfeRfePurReader;

class SmithBackgroundImage;

typedef struct
{
	double 						frequencyStart;
	double 						frequencyStop;
	double 						frequencyStep;
	QList<double>				frequencies;
    ushort 						timeout;
    uchar 						antenna;
    QVector<QrfeComplexNumber>	err1;
    QVector<QrfeComplexNumber>	err2;
    QVector<QrfeComplexNumber>	err3;
} CALIBRATION;

class CRfePurNetworkAnalyzer : public ReaderTabWidget, ConfigDialog
{
    Q_OBJECT

public:
    CRfePurNetworkAnalyzer(QTextEdit* infoEdit, QWidget *parent);
    ~CRfePurNetworkAnalyzer();

	virtual bool init(QrfeReaderInterface* reader);
	virtual void deinit();
	virtual void activated();

	virtual bool hasExecutionCount();

private slots:
	void saveCalibration();
	void loadCalibration();

	void calibrateButtonClicked();
	void startButtonClicked();
	void exportButtonClicked();

	void inputParametersChanged();
	void wizardPageChanged ( int id );
    void rescaleSmithPlot();

private:
	void createCalibrateWizard();
	void createAmplitudePlot();
	void createSmithPlot();

	void reloadMarkerList();
	void reloadLicenseData();

    void loadValuesFromCache();
    void saveValuesToCache();

protected:
	void resizeEvent ( QResizeEvent * event );

private slots:
	bool runCalibrationSweep ( QVector<QrfeComplexNumber> &output, QProgressBar* progress );
	void runMeasurementSweep ( );

private:
	bool calibrate ( const QVector< QrfeComplexNumber > & loadData, const QVector< QrfeComplexNumber > & shortData, const QVector< QrfeComplexNumber > & openData,
			QVector< QrfeComplexNumber > &err1, QVector< QrfeComplexNumber > &err2, QVector< QrfeComplexNumber > &err3);

	bool calculate ( const double frequency, const double portExtension,
					 const QrfeComplexNumber &err1, const QrfeComplexNumber &err2, const QrfeComplexNumber &err3,
					 const QrfeComplexNumber M,
	                 QrfeComplexNumber &reflection, QrfeComplexNumber& impedance, double &amplitude, double &phase);

	QrfeComplexNumber 	calculatef11 ( const QrfeComplexNumber& Mload, const QrfeComplexNumber& Mopen, const QrfeComplexNumber& Mshort );
	QrfeComplexNumber 	calculatef21 ( const QrfeComplexNumber& Mload, const QrfeComplexNumber& Mopen, const QrfeComplexNumber& Mshort, const QrfeComplexNumber& f11, const QrfeComplexNumber& f22 );
	QrfeComplexNumber 	calculatef22 ( const QrfeComplexNumber& Mload, const QrfeComplexNumber& Mopen, const QrfeComplexNumber& Mshort, const QrfeComplexNumber& f11 );

private:
	typedef enum{
		MEASURE_LOAD,
		WAIT_LOAD,
		MEASURE_SHORT,
		WAIT_SHORT,
		MEASURE_OPEN,
		WAIT_OPEN,
		END,
	} WIZZARD_PAGES;

private:
    QrfeRfePurReader* 		m_reader;

    ushort 					m_maxAttenuation;

    Ui::CRfePurNetworkAnalyzerClass ui;

    QWizard*	 			m_calibrateWizard;
    QWizardPage*			m_calibrateLoad;
    QWizardPage*			m_calibrateLoadWait;
    QProgressBar*			m_calibrateLoadProgress;
    QWizardPage*			m_calibrateShort;
    QWizardPage*			m_calibrateShortWait;
    QProgressBar*			m_calibrateShortProgress;
    QWizardPage*			m_calibrateOpen;
    QWizardPage*			m_calibrateOpenWait;
    QProgressBar*			m_calibrateOpenProgress;
    QWizardPage*			m_calibrateEnd;
    QCheckBox*				m_calibrateEndSave;


	QwtPlot*				m_amplitudePlot;
	QwtPlotCurve*			m_amplitudeCurveOld;
	QwtPlotCurve*			m_amplitudeCurve;
	QwtPlotPicker* 			m_amplitudePicker;

	QwtPlot*				m_smithPlot;
	QwtPlotCurve*			m_smithCurveOld;
	QwtPlotCurve*			m_smithCurve;
	QwtPlotCurve*			m_smithMarker;
	QwtPlotPicker* 			m_smithPicker;

    QStandardItemModel* 	m_dataModel;

    bool 					m_calibrated;
    bool 					m_dataToExport;

    CALIBRATION				m_calibration;

    bool 					m_measurementActive;
    bool 					m_continueMeasurement;

    double 					m_portExtension;

    friend class SmithBackgroundImage;
};

#endif // CRFEPURNETWORKANALYZER_H
